// clouds.inc 

// choose 3 layers only
#declare cloud_layer1=0;
#declare cloud_layer2=0;
#declare cloud_layer3=0;
#declare cloud_layer4=1;
#declare cloud_layer5=1;

#declare cloud_area=clouds;

#declare cloud_dist=10000; 
#declare cloud_lower=0; // lowest /4
#declare cloud_scale=cloud_dist/10;


#if (cloud_layer1>0)
sphere { <0,cloud_lower,0>,cloud_dist-5000
    hollow on no_shadow
    pigment {
      bumps
      turbulence 0.3 
      octaves 2  
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,0>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.95)*<1.5,1,1>
    }
    finish { ambient cloud_light }
}
#end

#if (cloud_layer2>0)
sphere { <0,cloud_lower,0>,cloud_dist-4000
   hollow on no_shadow
    pigment {
      bumps
      turbulence 0.3
      octaves 4
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,0>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.96)*<1.5,1,1>
    }
    finish { ambient cloud_light }
}
#end

#if (cloud_layer3>0)
sphere { <0,cloud_lower,0>,cloud_dist-3000
   hollow on no_shadow
    pigment {
      bumps
      turbulence 0.9 
      octaves 6
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,0>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.97)*<1.5,1,1>
    }
    finish { ambient cloud_light }
}
#end
#if (cloud_layer4>0)
sphere { <0,cloud_lower,0>,cloud_dist-2000
   hollow on no_shadow
    pigment {
      bumps
      turbulence 0.9 
      octaves 8
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,0>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale-20)*<1.5,1,1>
    }
    finish { ambient cloud_light }
}
#end
#if (cloud_layer5>0)
sphere { <0,cloud_lower,0>,cloud_dist-1000
   hollow on no_shadow
    pigment {
      bumps
      turbulence 0.9 
      octaves 10
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,0>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.98)*<1.5,1,1>
    }
    finish { ambient cloud_light }
}
#end